
#ifdef DX_CC5_SEP_PLAT
#include "MW_ATP_define_flags.h"
#endif
#include "DX_VOS_BaseTypes.h"
#include "DX_VOS_Stdio.h"
#include "DX_VOS_Utils.h"
#include "DX_VOS_Mem.h"
#include "DX_VOS_String.h"
#include "DX_VOS_File.h"

#include "drmcommon.h"
#include "apiParams.h"
#include "tstparams.h"
#include "tstutils.h"

#include "blackbox_tst_api.h"
#include "devcertparser_tst_api.h"
#include "devicedevcert_tst_api.h"
#include "expreval_tst_api.h"
#include "crypto_tst_api.h"
#include "drmmanager_tst_api.h"
#include "viewrights_tst_api.h"
#include "xmlparser_tst_api.h"
#include "xmlbuilder_tst_api.h"
#include "hds_tst_api.h"
#include "header_tst_api.h"
#include "liceval_tst_api.h"
#include "utils_tst_api.h"
#include "synclist_tst_api.h"
#include "licparser_tst_api.h"
#include "licstore_tst_api.h"
#include "metering_tst_api.h"
#include "secstore_tst_api.h"
#include "devicestore_tst_api.h"
#include "secureclock_tst_api.h"

#ifdef _DX_BLACK_BOX_SIM
extern DRM_RESULT DRM_API OEM_setActionGroupCertPrivKey(DRM_CHAR *    f_wrapKey );
#endif

/************************* Structs ******************************/

typedef struct WMDRMApiInfo_t
{
    char       TST_descr [100];
    WMDRMTestAPI_t TST_method;
} WMDRMApiInfo_t;

typedef struct WMDRMTestInfo_t
{
    WMDRMPrePostTestFunc_t      preTCFunc;
    WMDRMPrePostTestFunc_t      postTCFunc;
    WMDRMApiInfo_t* apiMap;
} WMDRMTestInfo_t;

/************************* Defines ******************************/
#define DRM_TRUE  (1) 
#define DRM_FALSE (0)




/*
#define WMDRM_TST_DEF_FILE "filedep.txt"
#define WMDRM_BB_TST_DATA_PTH "Test\\blackbox\\"
#define WMDRM_CRYPTO_TST_DATA_PTH "Test\\crypto\\"
#define WMDRM_DEVCERTPARSER_TST_DATA_PTH "Test\\devcertparser\\"
#define WMDRM_DEVICEDEVCERT_TST_DATA_PTH "Test\\devicedevcert\\"
#define WMDRM_DEVICESTORE_TST_DATA_PTH "Test\\devicestore\\"
#define WMDRM_XMLPARSER_TST_DATA_PTH "Test\\xmlparser\\"
#define WMDRM_XMLBUILDER_TST_DATA_PTH "Test\\xmlbuilder\\"
#define WMDRM_HEADER_TST_DATA_PTH "Test\\header\\"
#define WMDRM_HDS_TST_DATA_PTH "Test\\hds\\"
#define WMDRM_EXPREVAL_TST_DATA_PTH "Test\\expreval\\"
#define WMDRM_LICEVAL_TST_DATA_PTH "Test\\liceval\\"
#define WMDRM_VIEWRIGHTS_TST_DATA_PTH "Test\\viewrights\\"
#define WMDRM_UTILS_TST_DATA_PTH "Test\\utils\\"
#define WMDRM_SYNCLIST_TST_DATA_PTH "Test\\synclist\\"
#define WMDRM_LICPARSER_TST_DATA_PTH "Test\\licparser\\"
#define WMDRM_LICSTORE_TST_DATA_PTH "Test\\licstore\\"
#define WMDRM_DRMMANAGER_TST_DATA_PTH "Test\\drmmanager\\"
#define WMDRM_METERING_TST_DATA_PTH "Test\\metering\\"
#define WMDRM_SECSTORE_TST_DATA_PTH "Test\\secstore\\"
#define WMDRM_SECURECLOCK_TST_DATA_PTH "Test\\secureclock\\"
*/

#define WMDRM_TST_DEF_FILE "filedep.txt"
#define WMDRM_BB_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "blackbox" DX_VOS_PATH_DIVIDER
#define WMDRM_CRYPTO_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "crypto" DX_VOS_PATH_DIVIDER
#define WMDRM_DEVCERTPARSER_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "devcertparser" DX_VOS_PATH_DIVIDER
#define WMDRM_DEVICEDEVCERT_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "devicedevcert" DX_VOS_PATH_DIVIDER
#define WMDRM_DEVICESTORE_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "devicestore" DX_VOS_PATH_DIVIDER
#define WMDRM_XMLPARSER_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "xmlparser" DX_VOS_PATH_DIVIDER
#define WMDRM_XMLBUILDER_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "xmlbuilder" DX_VOS_PATH_DIVIDER
#define WMDRM_HEADER_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "header" DX_VOS_PATH_DIVIDER
#define WMDRM_HDS_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "hds" DX_VOS_PATH_DIVIDER
#define WMDRM_EXPREVAL_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "expreval" DX_VOS_PATH_DIVIDER
#define WMDRM_LICEVAL_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "liceval" DX_VOS_PATH_DIVIDER
#define WMDRM_VIEWRIGHTS_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "viewrights" DX_VOS_PATH_DIVIDER
#define WMDRM_UTILS_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "utils" DX_VOS_PATH_DIVIDER
#define WMDRM_SYNCLIST_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "synclist" DX_VOS_PATH_DIVIDER
#define WMDRM_LICPARSER_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "licparser" DX_VOS_PATH_DIVIDER
#define WMDRM_LICSTORE_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "licstore" DX_VOS_PATH_DIVIDER
#define WMDRM_DRMMANAGER_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "drmmanager" DX_VOS_PATH_DIVIDER
#define WMDRM_METERING_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "metering" DX_VOS_PATH_DIVIDER
#define WMDRM_SECSTORE_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "secstore" DX_VOS_PATH_DIVIDER
#define WMDRM_SECURECLOCK_TST_DATA_PTH "Test" DX_VOS_PATH_DIVIDER "secureclock" DX_VOS_PATH_DIVIDER



#if defined(PK_TEST)
#define SUPPORTED_TEST_PLATFORMS {".tc.", ".pk.", NULL}

#elif defined(WINCE_TEST)
#if defined(WINCE_TEST_PMC)
#define SUPPORTED_TEST_PLATFORMS {".tc.", ".ce.", ".pm.", NULL}

#elif defined(WINCE_TEST_CALLISTO)
#define SUPPORTED_TEST_PLATFORMS {".tc.", ".ce.", ".ca.", NULL}

#else
#define SUPPORTED_TEST_PLATFORMS {".tc.", ".ce.", NULL}
#endif

#else 
/* assume PC_TEST is defined */
#define SUPPORTED_TEST_PLATFORMS {".tc.", ".pc.", NULL}
#endif

/************************ Global data ****************************/

/********************* Private functions *************************/

/************** XML Logger Functions ***************/

/* create a log file. If there is an existed one from previous run, delete it */
DxStatus _InitXMLLogger(DxVosFile* logFileHandle_ptr, DxChar* testsPath)
{
    DxChar fullPath[WMDRM_MAX_PATH_LEN];
    DxStatus status = DX_FAILURE;
    DxChar logFileName[WMDRM_MAX_FILE_NAME_LEN];
    DxChar tmpPath[WMDRM_MAX_PATH_LEN] = "Test/";
    DxChar xmlExt[] = ".xml";

    DX_VOS_SPrintf(logFileName, WMDRM_MAX_FILE_NAME_LEN, "%s", testsPath + DX_VOS_StrLen(tmpPath));
    DX_VOS_SPrintf(logFileName + DX_VOS_StrLen(logFileName) - 1 \
    , WMDRM_MAX_FILE_NAME_LEN - DX_VOS_StrLen(logFileName) + 1, "%s", xmlExt);

    DX_VOS_SPrintf(fullPath, WMDRM_MAX_PATH_LEN, "%s%s", WMDRM_TST_OUTPUT_PTH, logFileName);
    
        //sprintf(szFullPath,"%s.xml",szExeNameWithoutExtension);


    /*delete the old file if there is any one*/
    status = DX_VOS_FOpen(logFileHandle_ptr, fullPath, "w+");
    if (DX_SUCCESS != status)
    {
        goto END_LABEL;
    }
    if(logFileHandle_ptr != DX_NULL)
    {
        status = DX_VOS_FClose(*logFileHandle_ptr);
        if (DX_SUCCESS != status)
        {
            goto END_LABEL;
        }
    }

    /*open for appending mode*/ 
    status = DX_VOS_FOpen(logFileHandle_ptr, fullPath, "w+");
    if (DX_SUCCESS != status)
    {
        goto END_LABEL;
    }

    DX_VOS_FPrintf(*logFileHandle_ptr, "<LOGSUMMARY>");
    
END_LABEL:
    return status;
}


/*close the file*/
DxStatus _UnInitXMLLogger(DxVosFile logFileHandle)
{
    DxStatus status = DX_FAILURE;

    if (DX_NULL != logFileHandle)
    {
        DX_VOS_FPrintf(logFileHandle, "</LOGSUMMARY>");
        status = DX_VOS_FClose(logFileHandle);
        if (DX_SUCCESS != status)
        {
            /* unexpected error */
        }
    }

    return status;
}

/* log to text file */
DxStatus _LogXMLStart(DxVosFile logFileHandle, DxUint32_t lTC)
{
    DxStatus status = DX_FAILURE;
    DxChar logMessage[WMDRM_MAX_STRING_LEN] = {0};

    if (DX_NULL == logFileHandle)
    {
        goto END_LABEL;
    }
    
    DX_VOS_SPrintf(logMessage, WMDRM_MAX_STRING_LEN, "<LOGRESULTS CaseNo=\"%d\" ", lTC);
    status = DX_VOS_FPrintf(logFileHandle, "%s", logMessage);

END_LABEL:
    return status;
}

DxStatus _LogXMLEnd(DxVosFile logFileHandle, DRM_RESULT testResult, DxChar *title, DxChar *trace)
{
    DxStatus status = DX_FAILURE;
    DxChar logMessage[WMDRM_MAX_STRING_LEN] = {0};

    if (DX_NULL == logFileHandle)
    {
        goto END_LABEL;
    }

    /* If the test cases failed, log the result */
    DX_VOS_MemSetZero(logMessage, sizeof(logMessage));
    DX_VOS_SPrintf(logMessage, WMDRM_MAX_STRING_LEN, "Result=\"%s\">\n", testResult? "FAIL":"PASS");
    status = DX_VOS_FPrintf(logFileHandle, "%s", logMessage);
    if (DX_SUCCESS != status)
    {
        goto END_LABEL;
    }

    if(DX_NULL != title)
    {
        DX_VOS_MemSetZero(logMessage, sizeof(logMessage));
        DX_VOS_SPrintf(logMessage, WMDRM_MAX_STRING_LEN, "<Title>%s</Title>\n", title); 
        status = DX_VOS_FPrintf(logFileHandle, "%s", logMessage);
        if (DX_SUCCESS != status)
        {
            goto END_LABEL;
        }
    }
    if(DX_NULL != trace)
    {
        DX_VOS_MemSetZero(logMessage, sizeof(logMessage));
        DX_VOS_SPrintf(logMessage, WMDRM_MAX_STRING_LEN, "<Trace>%s</Trace>\n", trace);
        status = DX_VOS_FPrintf(logFileHandle, "%s", logMessage);
        if (DX_SUCCESS != status)
        {
            goto END_LABEL;
        }
    }

    status = DX_VOS_FPrintf(logFileHandle, "</LOGRESULTS>\n");
  
END_LABEL:
    return status;
}

/***************************************************/

static DxUint32_t _TCSystemTest(DxChar* tcFileName)
{
    DxUint32_t searchRes = 0, i = 0;
    DxChar* pointerToEntry = DX_NULL;
    DxChar* supportedPlatforms[] = SUPPORTED_TEST_PLATFORMS;

    do 
    {
        pointerToEntry = DX_VOS_FindStr(tcFileName, supportedPlatforms[i]);
        if (pointerToEntry != DX_NULL)
        {
            ++searchRes;
        }
        ++i;

    } while(supportedPlatforms[i] != DX_NULL);

    return searchRes;
}



/**
*   _StringConcat
*
*   @brief The function concatenates two strings and put the result in third resulting string
*
*   @param s1               [in] pointer to the first string
*   @param s1LenInBytes     [in] length of the first string in bytes
*   @param s2               [in] pointer to the second string
*   @param s2LenInBytes     [in] length of the second string in bytes
*   @param resStr           [in] pointer to the resulting string
*   @param resStrLenInBytes [in] length of the resulting string in bytes
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success, otherwise DRM_S_FALSE
*/
static DRM_RESULT _StringConcat(DxChar* s1
                             , DxUint32_t s1LenInBytes
                             , DxChar* s2
                             , DxUint32_t s2LenInBytes
                             , DxChar* resStr
                             , DxUint32_t resStrLenInBytes)
{
    DxUint32_t i = 0;
    DRM_RESULT cmpResult = DRM_SUCCESS;

    DX_VOS_MemSet(resStr, 0, resStrLenInBytes);

    if (DX_SUCCESS != DX_VOS_StrNCopy(resStr, resStrLenInBytes, s1))
    {
        cmpResult = DRM_S_FALSE;
    }
    if (DX_SUCCESS != DX_VOS_StrNCopy(resStr + s1LenInBytes, resStrLenInBytes - s1LenInBytes, s2))
    {
        cmpResult = DRM_S_FALSE;
    }

    for (i = resStrLenInBytes; i > 0; --i)
    {
        if ((resStr[i] == 10) || resStr[i] == 13)
        {
            resStr[i] = 0;
        }
    }

    return cmpResult;
}

/**
*   _WMDRM_BVTTestsFinish
*
*   @brief The function checks the string if it contains expression "BVT ends here"
*
*   @param strBuffer               [in] pointer to the string
*   @param strBufferLenInBytes     [in] length of the string in bytes
*
*   @return DRM_RESULT
*           - DRM_SUCCESS if string contains expression "BVT ends here", otherwise DRM_S_FALSE
*/
static DRM_RESULT _WMDRM_BVTTestsFinish(DxChar *strBuffer, DxUint32_t strBufferLenInBytes)
{
    DRM_RESULT cmpResult = DRM_S_FALSE;
    DxUint32_t i = 0;
    DxChar bvtMsg[] = "BVT ends here";

    if (strBuffer[0] != '-')
    {
        goto END_LABEL;
    }

    do
    {
        ++i;
    }while ((strBuffer[i] == '-') && (i != strBufferLenInBytes));


    if(strBufferLenInBytes == i)
    {
        goto END_LABEL;
    }

    if(!DX_VOS_MemCmp(bvtMsg, strBuffer + i, sizeof(bvtMsg) - 1))
    {
       cmpResult = DRM_SUCCESS;
    }

END_LABEL:
    return cmpResult;
}

/**
*   _WMDRM_EmptyStringTests
*
*   @brief The function checks the string if it is empty
*
*   @param strBuffer               [in] pointer to the string
*   @param strBufferLenInBytes     [in] length of the string in bytes
*
*   @return DRM_RESULT
*           - DRM_SUCCESS if string is empty, otherwise DRM_S_FALSE
*/
static DRM_RESULT _WMDRM_EmptyStringTests(DxChar *strBuffer, DxUint32_t strBufferLenInBytes)
{
    DRM_RESULT cmpResult = DRM_S_FALSE;
    DxUint32_t i = 0;

    while ((strBuffer[i] == ' ') && (i != strBufferLenInBytes))
    {
        ++i;
    }

    if ((!DX_VOS_StrNCmp("\n", strBuffer + i, WMDRM_MAX_STRING_LEN)) || (!DX_VOS_StrNCmp("", strBuffer + i, WMDRM_MAX_STRING_LEN)))
    {
        cmpResult = DRM_SUCCESS;
    }
    
    return cmpResult;
}

/**
*   _WMDRM_APIRunner
*
*   @brief The function runs the DRM TC APIs from TC file
*
*   @param fp      [in] pointer to the TC file handle
*   @param tstData [in] pointer to the API map of current group of tests
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of successful execution of all tests of current group, otherwise DRM_S_FALSE
*/
static void _WMDRM_APIRunner(DxVosFile* fp, DxVosFile logFileHandle, WMDRMTestInfo_t* tstData)
{
    DRM_RESULT testResult = DRM_SUCCESS;
    DRM_RESULT errorCode = DRM_SUCCESS;
    DRM_RESULT bvtSearchResult = DRM_S_FALSE;
    DRM_RESULT testSwitch = DRM_S_FALSE;
    DxChar strBuffer[WMDRM_MAX_STRING_LEN];
    TAPIParams testFuncParams = {NULL, 0, NULL, 0, DRM_S_FALSE};
    DxUint32_t i = 0;
    DxChar traceMsg[WMDRM_MAX_STRING_LEN] = {0};

    DxUint32_t nextTcNumber = 0;
    DxUint32_t currTcNumber = 0;
    DxChar* apiTCName = NULL;
    DxChar TCName[WMDRM_MAX_STRING_LEN];
    DRM_BOOL prevTCEndFlag = DRM_FALSE;
    
    do 
    {
        testResult = DRM_SUCCESS;
		testResult = DX_VOS_FGets(*fp, strBuffer, sizeof(strBuffer));
		if (DX_SUCCESS != testResult)
        {
            DX_VOS_Printf("File read operation ERROR... 0X%X",testResult);
            DX_VOS_Printf("\n %s",strBuffer);
            testResult = DRM_S_FALSE;
            goto END_LABEL;
        }
        
		if((strBuffer[0] == '\'') || !strBuffer[0] )
		{
			continue;
		}
		if(!_WMDRM_EmptyStringTests(strBuffer,sizeof(strBuffer)))
		{
			continue;
		}
        bvtSearchResult = _WMDRM_BVTTestsFinish(strBuffer, sizeof(strBuffer));
        if (DRM_SUCCESS == bvtSearchResult)
        {
            continue;
        }
		if (DRM_TRUE == ParseTCID(strBuffer, (long *)&nextTcNumber, &apiTCName))
        {
			if (currTcNumber)
            {
				if(NULL != tstData->postTCFunc)
                {
					testResult = tstData->postTCFunc(currTcNumber, TCName);
				}
				if(testResult != 0x0)
				{
					DX_VOS_Printf("PostTestCase failed with %X.", testResult);
		            DX_VOS_Printf("%d: %s - TC Failed\n", currTcNumber, TCName);
				    _LogXMLEnd(logFileHandle, 0x1, TCName, DX_NULL);
				}
				else
				{
					DX_VOS_Printf("%d: %s - TC Passed\n", currTcNumber, TCName);
					_LogXMLEnd(logFileHandle, 0x0, TCName, DX_NULL);
				}
			}
			currTcNumber = nextTcNumber;
            DX_VOS_StrNCopy(TCName, sizeof(TCName), apiTCName);
            _LogXMLStart(logFileHandle, currTcNumber);
            if(NULL != tstData->preTCFunc)
            {
				testResult = tstData->preTCFunc(currTcNumber, apiTCName);
				if(testResult != DRM_SUCCESS)
				{
					DX_VOS_Printf("PreTestCase failed with %X.", testResult);
		            DX_VOS_Printf("%d: %s - TC Failed\n", currTcNumber, TCName);
					if(NULL != tstData->postTCFunc)
					{
						testResult = tstData->postTCFunc(currTcNumber, TCName);
						currTcNumber = 0;
					}
				    _LogXMLEnd(logFileHandle, 0x1, TCName, DX_NULL);
				}
			}
		}
		else if( (currTcNumber) && ParseAPI((char*)strBuffer, &testFuncParams))
		{
			DRM_BOOL fFail = FALSE;
			i = 0;
			while (tstData->apiMap[i].TST_method && DX_VOS_StrCmp(tstData->apiMap[i].TST_descr, testFuncParams.m_szAPIName))
			++i;
		
			if (tstData->apiMap[i].TST_method)
			{
					testResult = tstData->apiMap[i].TST_method(testFuncParams.m_lParamCount, testFuncParams.m_szParams);
			}
			else
			{
				testResult = DRM_E_NOTIMPL;
			}
			if (testFuncParams.m_fExcept && (testResult == testFuncParams.m_drExpected)) 
			{
				DX_VOS_MemSetZero(traceMsg, sizeof(traceMsg));
				DX_VOS_SPrintf(traceMsg, sizeof(traceMsg),"API_Failure: api returns a value which does not match the expected. API %s returns %d(0X%X). Expecting %d(0X%X).", testFuncParams.m_szAPIName, errorCode, errorCode, testFuncParams.m_drExpected, testFuncParams.m_drExpected);
				fFail = TRUE;
			/* api returns a value which does not match the expected. */
			} else if (!testFuncParams.m_fExcept && testResult != testFuncParams.m_drExpected) 
			{ 
				DX_VOS_MemSetZero(traceMsg, sizeof(traceMsg));
				DX_VOS_SPrintf(traceMsg, sizeof(traceMsg),"API_Failure: api returns a value which does not match the expected. API %s returns %d(0X%X). Expecting %d(0X%X).", testFuncParams.m_szAPIName, testResult, testResult, testFuncParams.m_drExpected, testFuncParams.m_drExpected);
				fFail = TRUE;
			}

			if (fFail) 
			{ /* api test failed, so the test case fails*/
				if(NULL != tstData->postTCFunc)
                {
					tstData->postTCFunc(currTcNumber, TCName);
				}
				DX_VOS_Printf("%d: %s - TC Failed\n", currTcNumber, TCName);
                _LogXMLEnd(logFileHandle, fFail, TCName, traceMsg);
				currTcNumber = 0;
			}
		}

    } while(DX_VOS_END_OF_FILE != DX_VOS_FEof(*fp));

	if (currTcNumber)
    {
		if(NULL != tstData->postTCFunc)
        {
			tstData->postTCFunc(currTcNumber, TCName);
		}
        DX_VOS_Printf("%d: %s - TC Passed\n", currTcNumber, TCName);
        _LogXMLEnd(logFileHandle, 0x0, TCName, DX_NULL);
	}

END_LABEL:

    return;
}

static DRM_RESULT _LoadTestDependFiles(DxChar* tstPath)
{
    DxVosFile fpFD = DX_NULL;
    DxChar  tcItem[WMDRM_MAX_FILE_NAME_LEN];
    DxChar tmpPath[WMDRM_MAX_PATH_LEN] = WMDRM_TST_BASE_PATH;
    DxChar tmpDstPath[WMDRM_MAX_PATH_LEN] = WMDRM_TST_APP_PTH;
	DxChar fullPath[WMDRM_MAX_PATH_LEN];
    DxStatus rc = DX_SUCCESS;
	DxUint32_t tPathSize;
#if 1//def DX_CC5_SEP_PLAT
	DRM_CONST_STRING srcFile = {0}, dstFile = {0};
	DRM_BOOL fRet; 
	DRM_BYTE *pbData = 0x0;
	DRM_DWORD cbData = 0x0;
#endif

    DX_VOS_SPrintf(tmpPath + DX_VOS_StrLen(tmpPath), sizeof(tmpPath) - DX_VOS_StrLen(tmpPath), "%s", tstPath); 
    _StringConcat(tmpPath 
        , (DxUint32_t)DX_VOS_StrLen(tmpPath)
        , WMDRM_TST_DEF_FILE
        , (DxUint32_t)DX_VOS_StrLen(WMDRM_TST_DEF_FILE)
        , fullPath
        , sizeof(fullPath));

	/*DX_VOS_Printf("fullPath - '%s'\n",fullPath);*/
	rc = DX_VOS_FOpen(&fpFD, fullPath, "r+");
    if(DX_SUCCESS != rc)
    {
        DX_VOS_Printf("\n%s (filedep.txt) file open ERROR!\n", fullPath);
        goto END_LABEL;
    }

    do 
    {
        if (DX_SUCCESS != (rc= DX_VOS_FGets(fpFD, tcItem, sizeof(tcItem))))
        {
            DX_VOS_Printf("File filedep.txt read operation ERROR...");
            goto END_LABEL;
        }
		
		if(!_WMDRM_EmptyStringTests(tcItem, DX_VOS_StrLen(tcItem)))
		{
			continue;
		}

		if(tcItem[DX_VOS_StrLen(tcItem) - 1 ] == 0xA)
		{
			tcItem[DX_VOS_StrLen(tcItem) - 1 ] = 0x0;
		}		

		if(DX_VOS_FindStr(tcItem,"$(_DRM_OEM_FILES)"))
		{
			tPathSize = DX_VOS_StrLen("$(_DRM_OEM_FILES)");
			_StringConcat(WMDRM_TST_SAMPLES_PTH 
				, (DxUint32_t)DX_VOS_StrLen(WMDRM_TST_SAMPLES_PTH)
				, &tcItem[tPathSize]
				, (DxUint32_t)DX_VOS_StrLen(tcItem) - tPathSize
				, fullPath
				, sizeof(fullPath));
		}
		else if(DX_VOS_FindStr(tcItem,"_DRM_REFCODE_TEST_FILES"))
		{
			tPathSize = DX_VOS_StrLen("$(_DRM_REFCODE_TEST_FILES)");
			_StringConcat(WMDRM_TST_COMMON_PTH 
				, (DxUint32_t)DX_VOS_StrLen(WMDRM_TST_COMMON_PTH)
				, &tcItem[tPathSize]
				, (DxUint32_t)DX_VOS_StrLen(tcItem) - tPathSize
				, fullPath
				, sizeof(fullPath));
		}
		else
		{
			tPathSize = 0;
			_StringConcat(tmpPath 
				, (DxUint32_t)DX_VOS_StrLen(tmpPath)
				, tcItem
				, (DxUint32_t)DX_VOS_StrLen(tcItem)
				, fullPath
				, sizeof(fullPath));
		}

		DX_VOS_SPrintf(&tmpDstPath[0], sizeof(tmpDstPath), "%s", WMDRM_TST_APP_PTH); 		
		DX_VOS_SPrintf(tmpDstPath + DX_VOS_StrLen(tmpDstPath), sizeof(tmpDstPath) - DX_VOS_StrLen(tmpDstPath), "%s", &tcItem[tPathSize]); 
#if 0//ndef DX_CC5_SEP_PLAT 
		DX_VOS_CopyFile (fullPath,tmpDstPath,TRUE);
#else
		MakeDRMString(&srcFile, fullPath);
		MakeDRMString(&dstFile, tmpDstPath);


		fRet = LoadTestFileW(DX_NULL, srcFile.pwszString, &pbData, &cbData);

		if(fRet != TRUE)
		{
	        DX_VOS_Printf("\n%s file open ERROR!\n",fullPath);
	        goto END_LABEL;
		}
		fRet = SaveToFileW(dstFile.pwszString, pbData, cbData);
		if(fRet != TRUE)
		{
	        DX_VOS_Printf("\n%s file save ERROR!\n",tmpDstPath);
	        goto END_LABEL;
		}
		DX_VOS_MemFree((DRM_VOID*)srcFile.pwszString);
		DX_VOS_MemFree((DRM_VOID*)dstFile.pwszString);
		DX_VOS_MemFree((DRM_VOID*)pbData);
		pbData = DX_NULL;
		cbData = 0x0;

#endif
        DX_VOS_MemSet(tcItem, 0, sizeof(tcItem));

    } while(DX_VOS_END_OF_FILE != DX_VOS_FEof(fpFD));

END_LABEL:

    if (DX_NULL != fpFD)
    {
        if(DX_SUCCESS != DX_VOS_FClose(fpFD))
        {
            DX_VOS_Printf("\nTC file close ERROR!\n");
        }
        fpFD = DX_NULL;
    }

    return rc;
}




/**
*   _TestFileManager
*
*   @brief The function processes the composite TC file filedep.txt (common to all groups) 
*
*   @param tstPath [in] pointer to string containing a path to TC files
*   @param tstData [in] pointer to the API map of current group of tests
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of successful execution of all tests of current group, otherwise DRM_S_FALSE
*/
static DRM_RESULT _TestFileManager(DxChar* tstPath, WMDRMTestInfo_t* tstData)
{
    DRM_RESULT testResult = DRM_S_FALSE;
    DxVosFile fp = DX_NULL;
    DxVosFile fpFD = DX_NULL;
    DxChar  tcItem[WMDRM_MAX_FILE_NAME_LEN];
    DxChar tmpPath[WMDRM_MAX_PATH_LEN] = WMDRM_TST_BASE_PATH;
    DxChar fullPath[WMDRM_MAX_PATH_LEN];
    DxVosFile logFileHandle = {0};
    DxStatus rc;

    
    DX_VOS_SPrintf(tmpPath + DX_VOS_StrLen(tmpPath), sizeof(tmpPath) - DX_VOS_StrLen(tmpPath), "%s", tstPath); 
    _StringConcat(tmpPath 
        , (DxUint32_t)DX_VOS_StrLen(tmpPath)
        , WMDRM_TST_DEF_FILE
        , (DxUint32_t)DX_VOS_StrLen(WMDRM_TST_DEF_FILE)
        , fullPath
        , sizeof(fullPath));
    rc = DX_VOS_FOpen(&fpFD, fullPath, "r+");
    if(DX_SUCCESS != rc)
    {
        DX_VOS_Printf("\nfiledep.txt file open ERROR!\n");
        goto END_LABEL;
    }

    _InitXMLLogger(&logFileHandle, tstPath);

    do 
    {
        if (DX_SUCCESS != DX_VOS_FGets(fpFD, tcItem, sizeof(tcItem)))
        {
            DX_VOS_Printf("File filedep.txt read operation ERROR...");
            testResult = DRM_S_FALSE;
            goto END_LABEL;
        }
        
        if(_TCSystemTest(tcItem))
        {
            if(DRM_SUCCESS != _WMDRM_EmptyStringTests(tcItem, sizeof(tcItem)))
            {
                if (tcItem[DX_VOS_StrLen(tcItem) - 1] == 10)
                {
                    tcItem[DX_VOS_StrLen(tcItem) - 1] = 0;
                }

				_StringConcat(WMDRM_TST_APP_PTH
                    , (DxUint32_t)DX_VOS_StrLen(WMDRM_TST_APP_PTH)
                    , tcItem
                    , (DxUint32_t)DX_VOS_StrLen(tcItem)
                    , fullPath
                    , sizeof(fullPath));
				if(DX_SUCCESS != DX_VOS_FOpen(&fp, fullPath, "r+"))
				{
                    DX_VOS_Printf("\nTC file open ERROR!\n");
                    goto END_LABEL;
                }

                _WMDRM_APIRunner(&fp, logFileHandle, tstData);

                if (DX_NULL != fp)
                {
                    if(DX_SUCCESS != DX_VOS_FClose(fp))
                    {
                        DX_VOS_Printf("\nTC file close ERROR!\n");
                    }
                    fp = DX_NULL;
                }
            }
        }
        DX_VOS_MemSet(tcItem, 0, sizeof(tcItem));

    } while(DX_VOS_END_OF_FILE != DX_VOS_FEof(fpFD));

END_LABEL:

    if (DX_NULL != fpFD)
    {
        if(DX_SUCCESS != DX_VOS_FClose(fpFD))
        {
            DX_VOS_Printf("\nTC file close ERROR!\n");
        }
        fpFD = DX_NULL;
    }

    if (DX_NULL != fp)
    {
        if(DX_SUCCESS != DX_VOS_FClose(fp))
        {
            DX_VOS_Printf("\nTC file close ERROR!\n");
        }
        fp = DX_NULL;
    }

    _UnInitXMLLogger(logFileHandle);

    return testResult;
}

/********************* Public functions **************************/

/**
*   WMDRM_BlackBoxAPITests
*
*   @brief The function runs Black Box APIs Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_BlackBoxAPITests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"Test_API_GetClientID", Test_API_GetClientID}
        , {"Test_CreateBindingInfo", Test_CreateBindingInfo}
        , {"Test_API_CanBind", Test_API_CanBind}
        , {"Test_VerifyClientID", Test_VerifyClientID}
        , {"Test_GenRandomBlob", Test_GenRandomBlob}
        , {"Test_API_HashValue", Test_API_HashValue}
        , {"Test_BlobOps", Test_BlobOps}
        , {"Test_PKEncryptLarge", Test_PKEncryptLarge}
        , {"Test_API_DecryptLicense", Test_API_DecryptLicense}
        , {"Test_API_CipherKeySetup", Test_API_CipherKeySetup}
        , {"Test_API_Encrypt", Test_API_Encrypt}
        , {"Test_API_Decrypt", Test_API_Decrypt}
        , {"Test_RenewBlackboxContext", Test_RenewBlackboxContext}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = BB_PreTestCase;
    tstData.postTCFunc = BB_PostTestCase;
    tstData.apiMap = apiMap;
	_LoadTestDependFiles(WMDRM_BB_TST_DATA_PTH);
    return _TestFileManager(WMDRM_BB_TST_DATA_PTH, &tstData);
}

/**
*   WMDRM_CryptoAPITests
*
*   @brief The function runs Crypto APIs Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_CryptoAPITests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"TestGenRandomData", TestGenRandomData}
        , {"TestMemComp", TestMemComp}
        , {"TestPKEncrypt_PKDecrypt", TestPKEncrypt_PKDecrypt}
        , {"TestPKSign_PKVerify", TestPKSign_PKVerify}
        , {"TestDRMCipher_Init", TestDRMCipher_Init}
        , {"TestDRMCipher_Encrypt", TestDRMCipher_Encrypt}
        , {"TestDRMCipher_Decrypt", TestDRMCipher_Decrypt}
        , {"TestShaInit", TestShaInit}
        , {"TestShaUpdate", TestShaUpdate}
        , {"TestShaDone", TestShaDone}
        , {"TestHMACInit", TestHMACInit}
        , {"TestHMACAdd", TestHMACAdd}
        , {"TestHMACDone", TestHMACDone}
        , {"TestDRM_rc4", TestDRM_rc4}
        , {"TestDeskey_Des", TestDeskey_Des}
        , {"TestCBC64WS4_asm", TestCBC64WS4_asm}
        , {"TestInvCBC64WS4_asm", TestInvCBC64WS4_asm}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = CRY_PreTestCase;
    tstData.postTCFunc = CRY_PostTestCase;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_CRYPTO_TST_DATA_PTH);
    return _TestFileManager(WMDRM_CRYPTO_TST_DATA_PTH, &tstData);
}

/**
*   WMDRM_DevCertParserTests
*
*   @brief The function runs Device certificate parser APIs Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_DevCertParserTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"TEST_API_DevCertGetAttribute", TEST_API_DevCertGetAttribute}
        , {"TEST_API_DevCertVerifyDeviceCert", TEST_API_DevCertVerifyDeviceCert}
        , {"TEST_ChangeDevcertNode", TEST_ChangeDevcertNode}
        , {"TEST_RollForwardClockInYears", TEST_RollForwardClockInYears}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = DCP_PreTestCase;
    tstData.postTCFunc = DCP_PostTestCase;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_DEVCERTPARSER_TST_DATA_PTH);
    return _TestFileManager(WMDRM_DEVCERTPARSER_TST_DATA_PTH, &tstData);
}

/**
*   WMDRM_DevCertGenerationTests
*
*   @brief The function runs Device certificate generation Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_DevCertGenerationTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"Test_RemoveDeviceData", Test_RemoveDeviceData}
        , {"Test_SetDeviceEnv", Test_SetDeviceEnv}
        , {"Test_API_GetDeviceCertificate", Test_API_GetDeviceCertificate}
        , {"Test_CompareDataBuffer", Test_CompareDataBuffer}
        , {"Test_VerifyDevcert", Test_VerifyDevcert}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = DDC_PreTestCase;
    tstData.postTCFunc = DDC_PostTestCase;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_DEVICEDEVCERT_TST_DATA_PTH);
    return _TestFileManager(WMDRM_DEVICEDEVCERT_TST_DATA_PTH, &tstData);
}

#if DRM_SUPPORT_DEVICESTORE
/**
*   WMDRM_DevStoreTests
*
*   @brief The function runs Device store Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_DevStoreTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"TestDeviceStoreRegisterDevice", TestDeviceStoreRegisterDevice}
        , {"TestDeviceStoreUnRegisterDevice", TestDeviceStoreUnRegisterDevice}
        , {"TestDeviceStoreCommitDevice", TestDeviceStoreCommitDevice}
        , {"TestDeviceStoreFreeDevice", TestDeviceStoreFreeDevice}
        , {"TestDeviceStoreGetDeviceByID", TestDeviceStoreGetDeviceByID}
        , {"TestDeviceStoreGetFirstDevice", TestDeviceStoreGetFirstDevice}
        , {"TestDeviceStoreGetNextDevice", TestDeviceStoreGetNextDevice}
        , {"TestDeviceStoreGetDeviceID", TestDeviceStoreGetDeviceID}
        , {"TestDeviceStoreSetDeviceAttr", TestDeviceStoreSetDeviceAttr}
        , {"TestDeviceStoreGetDeviceAttr", TestDeviceStoreGetDeviceAttr}
        , {"TestDeviceStoreGetDeviceAttrByIndex", TestDeviceStoreGetDeviceAttrByIndex}
        , {"TestDeviceStoreGetDeviceAttrCount", TestDeviceStoreGetDeviceAttrCount}
        , {"TestDeviceStoreChangeTime", TestDeviceStoreChangeTime}
        , {"TestDeviceStoreInitialize", TestDeviceStoreInitialize}
        , {"TestDeviceStoreUninitialize", TestDeviceStoreUninitialize}
        , {"TestDeviceStoreRegisterManyDevices", TestDeviceStoreRegisterManyDevices}
        , {"TestDeviceStoreUnRegisterManyDevices", TestDeviceStoreUnRegisterManyDevices}
        , {"TestDeviceStoreSetManyAttr", TestDeviceStoreSetManyAttr}
        , {"TestDeviceStoreGetManyAttr", TestDeviceStoreGetManyAttr}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = DS_PreTestCase;
    tstData.postTCFunc = DS_PostTestCase;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_DEVICESTORE_TST_DATA_PTH);
    return _TestFileManager(WMDRM_DEVICESTORE_TST_DATA_PTH, &tstData);
}
#endif

/**
*   WMDRM_DRMManagerTests
*
*   @brief The function runs Top level exposed (DRM Manager) APIs Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_DRMManagerTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"TestManagerReinitialize", TestManagerReinitialize}
        , {"TestManagerInitialize", TestManagerInitialize}
        , {"TestManagerChangeTime", TestManagerChangeTime}
#if DRM_SUPPORT_REVOCATION
        , {"TestManagerSetRevocationInfo", TestManagerSetRevocationInfo}
        , {"TestManagerSetRevocation", TestManagerSetRevocation}
        , {"TestManagerGetRevocationInfo", TestManagerGetRevocationInfo}
        , {"TestManagerGetRevocationList", TestManagerGetRevocationList}
        , {"TestUpdateRevocationVersionsCache", TestUpdateRevocationVersionsCache}
        , {"TestManagerStoreRevocationLists", TestManagerStoreRevocationLists}
        , {"TestManagerGetLicenseRevInfoVersion", TestManagerGetLicenseRevInfoVersion}
#endif
        , {"TestManagerSetRights", TestManagerSetRights}
        , {"TestManagerSetV2Header", TestManagerSetV2Header}
        , {"TestManagerGetLicenseData", TestManagerGetLicenseData}
        , {"TestManagerPrepareOPLCallback", TestManagerPrepareOPLCallback}
        , {"TestManagerBind", TestManagerBind}
        , {"TestManagerDecrypt", TestManagerDecrypt}
        , {"TestManagerCreateEncryptContext", TestManagerCreateEncryptContext}
        , {"TestManagerEncrypt", TestManagerEncrypt}
        , {"TestManagerCommit", TestManagerCommit}
        , {"TestManagerGenerateChallenge", TestManagerGenerateChallenge}
        , {"TestManagerInitResponse", TestManagerInitResponse}
        , {"TestManagerAddLicenseToResponse", TestManagerAddLicenseToResponse}
        , {"TestManagerGenerateResponse", TestManagerGenerateResponse}
        , {"TestManagerProcessResponse", TestManagerProcessResponse}
        , {"TestManagerInitializeForNewStore", TestManagerInitializeForNewStore}
        , {"TestManagerSetMachineClock", TestManagerSetMachineClock}
        , {"TestManagerGetDeviceProperty", TestManagerGetDeviceProperty}
        , {"TestManagerSetGetClockState", TestManagerSetGetClockState}
        , {"TestManagerCleanLicenseStore", TestManagerCleanLicenseStore}
        , {"TestEnumLicense", TestEnumLicense}
        , {"TestManagerGetSourceID", TestManagerGetSourceID}
        , {"TestManagerGetLicenseState", TestManagerGetLicenseState}
        , {"TestManagerMakeDeviceLicenseRevocationBlob", TestManagerMakeDeviceLicenseRevocationBlob}
        , {"TestManagerProcessDeviceLicenseRevocation", TestManagerProcessDeviceLicenseRevocation}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = DRMM_PreTestCase;
    tstData.postTCFunc = DRMM_PostTestCase;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_DRMMANAGER_TST_DATA_PTH);
    return _TestFileManager(WMDRM_DRMMANAGER_TST_DATA_PTH, &tstData);
}

/**
*   WMDRM_ExpressionEvalTests
*
*   @brief The function runs Expression evaluator (DRM Core) APIs Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_ExpressionEvalTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"TestDRMEvaluateExpression", TestDRMEvaluateExpression}
        , {"TestLicEvalContextSetting", XPV_TestLicEvalContextSetting}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = XPV_PreTestCase;
    tstData.postTCFunc = XPV_PostTestCase;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_EXPREVAL_TST_DATA_PTH);
    return _TestFileManager(WMDRM_EXPREVAL_TST_DATA_PTH, &tstData);
}

/**
*   WMDRM_HDSTests
*
*   @brief The function runs Low level hashed data store (DRM Core) APIs Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_HDSTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"TestDeleteFile", TestDeleteFile}
        , {"TestHdsBlockScanDelete", TestHdsBlockScanDelete}
        , {"TestHdsSlotWrite", TestHdsSlotWrite}
        , {"TestHdsSlotRead", TestHdsSlotRead}
        , {"TestHdsSlotSeek", TestHdsSlotSeek}
        , {"TestHdsSlotResize", TestHdsSlotResize}
        , {"TestHdsSlotEnumNext", TestHdsSlotEnumNext}
        , {"TestHdsInitSlotEnum", TestHdsInitSlotEnum}
        , {"TestHdsDeleteSlot", TestHdsDeleteSlot}
        , {"TestHdsCloseSlot", TestHdsCloseSlot}
        , {"TestHdsOpenSlot", TestHdsOpenSlot}
        , {"TestHdsCloseNamespace", TestHdsCloseNamespace}
        , {"TestHdsOpenNamespace", TestHdsOpenNamespace}
        , {"TestHdsDeleteNamespace", TestHdsDeleteNamespace}
        , {"TestHdsCommitStore", TestHdsCommitStore}
        , {"TestHdsCloseStore", TestHdsCloseStore}
        , {"TestHdsOpenStore", TestHdsOpenStore}
        , {"TestHdsCreateStore", TestHdsCreateStore}
        , {"TestHdsReinitialize", TestHdsReinitialize}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = HDS_PreTestCase;
    tstData.postTCFunc = HDS_PostTestCase;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_HDS_TST_DATA_PTH);
    return _TestFileManager(WMDRM_HDS_TST_DATA_PTH, &tstData);
}

/**
*   WMDRM_HeaderTests
*
*   @brief The function runs Header parser APIs to create challenge (DRM Core) Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_HeaderTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
       {"TestContentHeaderGetUplink", TestContentHeaderGetUplink}
        , {"TestContentHeaderGetAttribute", TestContentHeaderGetAttribute}
        , {"TestContentHeaderVerify", TestContentHeaderVerify}
        , {"TestLoadHeader", TestLoadHeader}
        , {"", NULL}
     };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = HD_PreTestCase;
    tstData.postTCFunc = HD_PostTestCase;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_HEADER_TST_DATA_PTH);
    return _TestFileManager(WMDRM_HEADER_TST_DATA_PTH, &tstData);
}

/**
*   WMDRM_LicenseParserTests
*
*   @brief The function runs License parser (DRM Core) APIs Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_LicenseParserTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"Test_API_LicenseGetAttribute", Test_API_LicenseGetAttribute}
        , {"Test_SetLicenseString", Test_SetLicenseString}
        , {"Test_API_LicenseGetEvent", Test_API_LicenseGetEvent}
        , {"Test_API_LicenseVerifySignature", Test_API_LicenseVerifySignature}
        , {"Test_API_LicenseVerifyCertChain", Test_API_LicenseVerifyCertChain}
        , {"Test_API_LicenseGetContentRevocation", Test_API_LicenseGetContentRevocation}
        , {"Test_API_LicenseVerifyContentRevocation", Test_API_LicenseVerifyContentRevocation}
        , {"Test_API_LicenseGetEnablingBits", Test_API_LicenseGetEnablingBits}
        , {"Test_SetTestKey", Test_SetTestKey}
        , {"Test_SetTestKeyByName", Test_SetTestKeyByName}
        , {"Test_MakeLicense", Test_MakeLicense}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = LP_PreTestCase;
    tstData.postTCFunc = LP_PostTestCase;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_LICPARSER_TST_DATA_PTH);
    return _TestFileManager(WMDRM_LICPARSER_TST_DATA_PTH, &tstData);
}

/**
*   WMDRM_LicenseStoreTests
*
*   @brief The function runs License store (DRM Core) APIs Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_LicenseStoreTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"TestLicStoreAddMultiLicenses", TestLicStoreAddMultiLicenses}
        , {"TestLicStoreReinitialize", TestLicStoreReinitialize}
        , {"TestLicStoreOpenStore", TestLicStoreOpenStore}
        , {"TestLicStoreCloseStore", TestLicStoreCloseStore}
        , {"TestLicStoreAddLicense", TestLicStoreAddLicense}
        , {"TestLicStoreGetLicenseKeys", TestLicStoreGetLicenseKeys}
        , {"TestLicStoreGetLicense", TestLicStoreGetLicense}
        , {"TestLicStoreInitEnum", TestLicStoreInitEnum}
        , {"TestLicStoreEnumNext", TestLicStoreEnumNext}
        , {"TestLicStoreEnumDelete", TestLicStoreEnumDelete}
        , {"TestLicStoreAddMultiLicenses", TestLicStoreAddMultiLicenses}
        , {"TestLicStoreLog", TestLicStoreLog}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = LS_PreTestCase;
    tstData.postTCFunc = LS_PostTestCase;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_LICSTORE_TST_DATA_PTH);
    return _TestFileManager(WMDRM_LICSTORE_TST_DATA_PTH, &tstData);
}

/**
*   WMDRM_LicenseEvalTests
*
*   @brief The function runs License evaluator (DRM Core) APIs Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_LicenseEvalTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"TestLicEvalContextSetting", TestLicEvalContextSetting}
        , {"TestLicenseEvalPerformOperations", TestLicenseEvalPerformOperations}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = LE_PreTestCase;
    tstData.postTCFunc = LE_PostTestCase;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_LICEVAL_TST_DATA_PTH);
    return _TestFileManager(WMDRM_LICEVAL_TST_DATA_PTH, &tstData);
}

/**
*   WMDRM_MeteringTests
*
*   @brief The function runs Metering collection, meter challenge and process reset Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_MeteringTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"TestDRM_VerifyTID", TestDRM_VerifyTID}
        , {"TestDRM_Manager_AddManyMeteringData", TestDRM_Manager_AddManyMeteringData}
        , {"TestDRM_Manager_AddMeteringData", TestDRM_Manager_AddMeteringData}
        , {"TestDRM_Manager_GeneratePartialMeterChallenge", TestDRM_Manager_GeneratePartialMeterChallenge}
        , {"TestDRM_Manager_GenerateMeterChallenge", TestDRM_Manager_GenerateMeterChallenge}
        , {"TestDRM_Manager_ProcessMeterResponse", TestDRM_Manager_ProcessMeterResponse}
        , {"TestDRM_Manager_Initialize", TestDRM_Manager_Initialize}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = MT_PreTestCase;
    tstData.postTCFunc = MT_PostTestCase;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_METERING_TST_DATA_PTH);
    return _TestFileManager(WMDRM_METERING_TST_DATA_PTH, &tstData);
}

/**
*   WMDRM_SecureStoreTests
*
*   @brief The function runs Secure Store (DRM Core) APIs Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_SecureStoreTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"TestDRM_SST_Initialize", TestDRM_SST_Initialize}
        , {"TestDRM_SST_GetData", TestDRM_SST_GetData}
        , {"TestDRM_SST_SetData", TestDRM_SST_SetData}
        , {"TestDRM_SST_OpenKeyTokens", TestDRM_SST_OpenKeyTokens}
        , {"TestDRM_SST_GetTokenValue", TestDRM_SST_GetTokenValue}
        , {"TestDRM_SST_SetTokenValue", TestDRM_SST_SetTokenValue}
        , {"TestDRM_SST_GetAllData", TestDRM_SST_GetAllData}
        , {"TestDRM_SST_CloseKey", TestDRM_SST_CloseKey}
        , {"TestDRM_SST_DeleteKey", TestDRM_SST_DeleteKey}
        , {"TestDRM_SST_OpenEnumerator", TestDRM_SST_OpenEnumerator}
        , {"TestDRM_SST_EnumNext", TestDRM_SST_EnumNext}
        , {"TestDRM_SST_CreateGlobalStorePassword", TestDRM_SST_CreateGlobalStorePassword}
        , {"TestDRM_SST_CreateLicenseStatePassword", TestDRM_SST_CreateLicenseStatePassword}
        , {"TestDRM_SST_OpenAndLockSlot", TestDRM_SST_OpenAndLockSlot}
        , {"TestDRM_SST_SetLockedData", TestDRM_SST_SetLockedData}
        , {"TestDRM_SST_GetLockedData", TestDRM_SST_GetLockedData}
        , {"TestDRM_SST_CloseLockedSlot", TestDRM_SST_CloseLockedSlot}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = SST_PreTestCase;
    tstData.postTCFunc = SST_PostTestCase;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_SECSTORE_TST_DATA_PTH);
    return _TestFileManager(WMDRM_SECSTORE_TST_DATA_PTH, &tstData);
}

#if DRM_SUPPORT_SECURE_CLOCK
/**
*   WMDRM_SecureClockTests
*
*   @brief The function runs Secure Clock APIs Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_SecureClockTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"Test_API_MGR_Initialize", Test_API_MGR_Initialize}
        , {"Test_SetSecureClock", Test_SetSecureClock}
        , {"Test_API_MGR_ClkGenerateChallenge", Test_API_MGR_ClkGenerateChallenge}
        , {"Test_SetChallengeState", Test_SetChallengeState}
        , {"Test_API_MGR_ClkProcessResponse", Test_API_MGR_ClkProcessResponse}
        , {"Test_ChangeClock", Test_ChangeClock}
        , {"Test_API_MGR_GetSecureClock", Test_API_MGR_GetSecureClock}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = SCLK_PreTestCase;
    tstData.postTCFunc = SCLK_PostTestCase;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_SECURECLOCK_TST_DATA_PTH);
    return _TestFileManager(WMDRM_SECURECLOCK_TST_DATA_PTH, &tstData);
}
#endif

/**
*   WMDRM_SyncListTests
*
*   @brief The function runs Sync challenge Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_SyncListTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"TestSyncListReset", TestSyncListReset}
        , {"TestGenerateSyncListChallenge", TestGenerateSyncListChallenge}
        , {"TestSetEnhancedData", TestSetEnhancedData}
        , {"TestAddLicenseToStore", TestAddLicenseToStore}
        , {"TestPlayback", TestPlayback}
        , {"TestSynclistChangeTime", TestSynclistChangeTime}
        , {"TestEnumLicense", TestEnumLicense_SL}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = SL_PreTestCase;
    tstData.postTCFunc = SL_PostTestCase;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_SYNCLIST_TST_DATA_PTH);
    return _TestFileManager(WMDRM_SYNCLIST_TST_DATA_PTH, &tstData);
}

/**
*   WMDRM_UtilsTests
*
*   @brief The function runs CRT and other utilities (DRM Core) Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_UtilsTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"TestAllocBuffer", TestAllocBuffer}
        , {"TestCompBuffer", TestCompBuffer}
        , {"TestSetBuffer", TestSetBuffer}
        , {"TestVerifyBuffer", TestVerifyBuffer}
        , {"Test_API_DRMCRT_memmove", Test_API_DRMCRT_memmove}
        , {"Test_API_DRMCRT_wcsntol", Test_API_DRMCRT_wcsntol}
        , {"Test_API_DRMCRT_strncmp", Test_API_DRMCRT_strncmp}
        , {"Test_API_DRMCRT_wcsncmp", Test_API_DRMCRT_wcsncmp}
        , {"Test_API_DRMCRT_wcslen", Test_API_DRMCRT_wcslen}
        , {"Test_API_DRMCRT_wcsncpy", Test_API_DRMCRT_wcsncpy}
        , {"Test_API_DRMCRT_abs", Test_API_DRMCRT_abs}
        , {"Test_API_DRMCRT_isxxx", Test_API_DRMCRT_isxxx}
        , {"Test_API_DRM_Base64Encode", Test_API_DRM_Base64Encode}
        , {"Test_API_DRM_Base64Decode", Test_API_DRM_Base64Decode}
        , {"Test_API_DecodeKID", Test_API_DecodeKID}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = U_PreTestCase;
    tstData.postTCFunc = U_PostTestCase;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_UTILS_TST_DATA_PTH);
    return _TestFileManager(WMDRM_UTILS_TST_DATA_PTH, &tstData);
}

/**
*   WMDRM_ViewRightsTests
*
*   @brief The function runs Top level view rights (DRM Core) APIs Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_ViewRightsTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"TestAddLicense", TestAddLicense}
        , {"TestIsAllowed", TestIsAllowed}
        , {"TestGetLicenseAggregateData", TestGetLicenseAggregateData}
        , {"TestVerifyStateData", TestVerifyStateData}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = VR_PreTestCase;
    tstData.postTCFunc = VR_PostTestCase;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_VIEWRIGHTS_TST_DATA_PTH);
    return _TestFileManager(WMDRM_VIEWRIGHTS_TST_DATA_PTH, &tstData);
}

/**
*   WMDRM_XMLBuilderTests
*
*   @brief The function runs XML Builder (DRM Core) APIs Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_XMLBuilderTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"TestXMLAppendNode", TestXMLAppendNode}
        , {"TestXMLAddCData", TestXMLAddCData}
        , {"TestXMLAddData", TestXMLAddData}
        , {"TestXMLAddAttribute", TestXMLAddAttribute}
        , {"TestXMLGetContextSize", TestXMLGetContextSize}
        , {"TestXMLGetCurrNodeName", TestXMLGetCurrNodeName}
        , {"TestXMLCloseCurrNode", TestXMLCloseCurrNode}
        , {"TestXMLOpenNode", TestXMLOpenNode}
        , {"TestXMLCloseDocument", TestXMLCloseDocument}
        , {"TestXMLReallocDocument", TestXMLReallocDocument}
        , {"TestXMLCreateDocument", TestXMLCreateDocument}
        , {"TestXMLUtilReinitialize", TestXMLUtilReinitialize_XMLB}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = NULL;
    tstData.postTCFunc = NULL;
    tstData.apiMap = apiMap;
	_LoadTestDependFiles(WMDRM_XMLBUILDER_TST_DATA_PTH);
    return _TestFileManager(WMDRM_XMLBUILDER_TST_DATA_PTH, &tstData);
}

/**
*   WMDRM_XMLParserTests
*
*   @brief The function runs XML Parser  (DRM Core) APIs Tests
*
*   @param none
*
*   @return DRM_RESULT
*           - DRM_SUCCESS in case of success
*           - DRM Error Code - in any case besides success
*/
DRM_RESULT WMDRM_XMLParserTests()
{

    WMDRMApiInfo_t apiMap[] = 
    {
        {"TestXMLUtilReinitialize", TestXMLUtilReinitialize}
        , {"TestXMLUtilGetXMLNode", TestXMLUtilGetXMLNode}
        , {"TestXMLUtilGetXMLSubNode", TestXMLUtilGetXMLSubNode}
        , {"TestXMLUtilGetXMLNodeAttribute", TestXMLUtilGetXMLNodeAttribute}
        , {"TestXMLUtilGetXMLNodeA", TestXMLUtilGetXMLNodeA}
        , {"TestXMLUtilGetXMLSubNodeA", TestXMLUtilGetXMLSubNodeA}
        , {"TestXMLUtilGetXMLNodeAttributeA", TestXMLUtilGetXMLNodeAttributeA}
        , {"TestXMLUtilGetXMLNodeCData", TestXMLUtilGetXMLNodeCData}
        , {"", NULL}
    };

    WMDRMTestInfo_t tstData;

    tstData.preTCFunc = NULL;
    tstData.postTCFunc = NULL;
    tstData.apiMap = apiMap;

	_LoadTestDependFiles(WMDRM_XMLPARSER_TST_DATA_PTH);
    return _TestFileManager(WMDRM_XMLPARSER_TST_DATA_PTH, &tstData);
}

void WMDRM_TestRun(WMDRMRunInfoPtr_t tstInfo_ptr)
{
    DRM_RESULT testResult = DRM_SUCCESS;

    DX_VOS_Printf("\n--------------------------------------------------------------------\n");
    DX_VOS_Printf("\n*** Starting %s... *** \n\n", tstInfo_ptr->TST_descr);

    testResult = (tstInfo_ptr->TST_method)();


    DX_VOS_Printf("\n--------------------------------------------------------------------\n");
    DX_VOS_Printf("*** Finish of %s... *** \n\n", tstInfo_ptr->TST_descr);
}





